/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of the Bus state dialog class

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file BusStateDlg.h
///  Definition file of the Bus State Get/Set dialog class
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxwin.h"
#include <stdint.h>

///////////////////////////////////////////////////////////////////////////////////////////
/// Bus State Get/Set Test dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CBusStateDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CBusStateDlg)

public:
	CBusStateDlg(CWnd* pParent = NULL);   // standard constructor
	virtual ~CBusStateDlg();

// Dialog Data
	enum { IDD = IDD_BUSSTATE };

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  uint32_t        m_ulSetTimeout;   //!< Timeout when calling Set Bus State
  CComboBox       m_cNewStateCtrl;  //!< Set Bus State Combobox Control

	DECLARE_MESSAGE_MAP()
public:
  afx_msg void OnBnClickedBtnGetstate();
  afx_msg void OnBnClickedBtnSetstate();
  afx_msg void OnEnKillfocusEdtTimeout();
  virtual BOOL OnInitDialog();
};
